/*** 1.   ũƮ ***/

SELECT id
	, DATEADD(ss,id-1,'2020-01-01') date
	, NEWID() code 
INTO TB_Date
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) id
      FROM master..spt_values a , (SELECT number 
	                              FROM master..spt_values b 
	 			   WHERE type = 'P' 
	 			   AND number <= 500) b
	 WHERE a.type = 'P'
) c

CREATE INDEX NIDX01_Date ON TB_Date (date) INCLUDE (id,code)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT id, date,code
FROM TB_Date
WHERE date BETWEEN '2020-01-01' AND '2020-01-04'
AND SUBSTRING(CONVERT(NVARCHAR, date, 121), 12, 12) = '00:00:00.000'
GO


/*** 6. [TO-BE]   ***/

SELECT id,date,code
FROM TB_Date
WHERE date IN ('2020-01-01 00:00:00.000'
		,'2020-01-02 00:00:00.000'
		,'2020-01-03 00:00:00.000'
		,'2020-01-04 00:00:00.000')
GO



